<?php

namespace Drupal\mapsemble\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Field plugin annotation object.
 *
 * @Annotation
 */
class FieldPlugin extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the field mapping plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The Drupal field types this mapping plugin applies to.
   *
   * @var array
   */
  public $drupal_field_types = [];

  /**
   * The Mapsemble field types this mapping plugin applies to.
   *
   * @var array
   */
  public $mapsemble_field_types = [];

}
