<?php

namespace Drupal\mapsemble\Annotation;

use Drupal\Component\Annotation\Plugin;

/**
 * Defines a Filter plugin annotation object.
 *
 * @Annotation
 */
class FilterPlugin extends Plugin {

  /**
   * The plugin ID.
   *
   * @var string
   */
  public $id;

  /**
   * The human-readable name of the filter plugin.
   *
   * @var \Drupal\Core\Annotation\Translation
   *
   * @ingroup plugin_translatable
   */
  public $label;

  /**
   * The field types this filter plugin applies to.
   *
   * @var array
   */
  public $field_types = [];

}
