<?php

namespace Drupal\mapsemble\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The FieldPlugin attribute for Mapsemble field mapping plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class FieldPlugin extends Plugin {

  /**
   * Construct a FieldPlugin attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The human-readable label for the plugin.
   * @param array $drupal_field_types
   *   The Drupal field types this plugin applies to.
   * @param array $mapsemble_field_types
   *   The Mapsemble field types this plugin applies to.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly array $drupal_field_types = [],
    public readonly array $mapsemble_field_types = [],
  ) {}

}
