<?php

namespace Drupal\mapsemble\Attribute;

use Drupal\Component\Plugin\Attribute\Plugin;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * The FilterPlugin attribute for Mapsemble filter plugins.
 */
#[\Attribute(\Attribute::TARGET_CLASS)]
class FilterPlugin extends Plugin {

  /**
   * Construct a FilterPlugin attribute.
   *
   * @param string $id
   *   The plugin ID.
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $label
   *   The human-readable label for the plugin.
   * @param array $field_types
   *   The field types this filter plugin applies to.
   */
  public function __construct(
    public readonly string $id,
    public readonly ?TranslatableMarkup $label = NULL,
    public readonly array $field_types = [],
  ) {}

}
