<?php

namespace Drupal\mapsemble\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Symfony\Component\HttpFoundation\Exception\BadRequestException;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for bare content without site theming.
 */
class MapsembleControllerBase extends ControllerBase {

  /**
   * The Mapsemble map ID.
   *
   * @var string
   */
  protected string $mapId;

  /**
   * The remote entity ID.
   *
   * @var string
   */
  protected string $remoteId;

  /**
   * The requested language code.
   *
   * @var string
   */
  protected string $language;

  /**
   * The filters passed from the request.
   *
   * @var array
   */
  protected array $filters = [];

  /**
   * Constructs a MarkerController object.
   *
   * @param \Symfony\Component\EventDispatcher\EventDispatcherInterface $eventDispatcher
   *   The event dispatcher.
   * @param \Symfony\Component\HttpFoundation\Request $currentRequest
   *   The current request.
   */
  public function __construct(
    protected readonly EventDispatcherInterface $eventDispatcher,
    protected readonly Request $currentRequest,
  ) {
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('event_dispatcher'),
      $container->get('request_stack')->getCurrentRequest(),
    );
  }

  /**
   * Handles and validates the incoming request parameters.
   */
  public function handleRequest(): void {
    $this->remoteId = $this->currentRequest->query->get('remoteId') ?? '';
    if ($filters = ($this->currentRequest->query->get('filters') ?? '')) {
      if (($decoded = json_decode($filters, TRUE)) && is_array($decoded)) {
        $this->filters = $decoded;
      }
      json_decode($filters);
    }
    $this->language = $this->currentRequest->query->get('language') ?? '';
    $this->mapId = $this->currentRequest->query->get('map') ?? '';

    if (empty($this->remoteId)) {
      throw new BadRequestException('No remoteId provided');
    }
  }

}
