<?php

declare(strict_types=1);

namespace Drupal\mapsemble\Drush\Commands;

use Drupal\Core\Utility\Token;
use Drupal\mapsemble\Entity\MapsembleMap;
use Drupal\mapsemble\MapsembleApi;
use Drush\Attributes as CLI;
use Drush\Commands\AutowireTrait;
use Drush\Commands\DrushCommands;

/**
 * A Drush commandfile.
 */
final class MapsembleCommands extends DrushCommands {

  use AutowireTrait;

  /**
   * Constructs a MapsembleCommands object.
   */
  public function __construct(
    private readonly Token $token,
    private readonly MapsembleApi $mapsembleApi,
  ) {
    parent::__construct();
  }

  /**
   * Command description here.
   */
  #[CLI\Command(name: 'mapsemble:sync', aliases: ['mapsemble-sync'])]
  #[CLI\Argument(name: 'map', description: 'Map machine name')]
  #[CLI\Usage(name: 'mapsemble:sync map', description: 'Synchronize your data with mapsemble')]
  public function syncData(string $map) {
    $map = MapsembleMap::load($map);
    if ($map) {
      $batch_builder = $this->mapsembleApi->buildBatchForSyncing($map);
      batch_set($batch_builder->toArray());

      // Process the batch manually since Drush has no UI.
      drush_backend_batch_process();
    }
    else {
      $this->output()->writeln('Map not found');
    }
  }

}
