<?php

namespace Drupal\mapsemble\Event;

/**
 * Event that is fired when a card is being generated.
 */
class MapsembleContentEventBase extends MapsembleEventBase {
  /**
   * The event name.
   */
  const EVENT_NAME = 'mapsemble.content';

  public function __construct(
    string $remoteId = '',
    array $filters = [],
    string $locale = '',
    array $content = [],
  ) {
    parent::__construct($remoteId, $filters, $locale);
    $this->content = $content;
  }

  /**
   * Sets the content payload for this event.
   *
   * @param array $content
   *   The content array.
   *
   * @return $this
   */
  public function setContent(array $content): MapsembleContentEventBase {
    $this->content = $content;
    return $this;
  }

  /**
   * The content payload to be consumed by listeners.
   *
   * @var array
   */
  protected array $content;

  /**
   * Gets the content payload.
   *
   * @return array
   *   The content array.
   */
  public function getContent(): array {
    return $this->content;
  }

}
