<?php

declare(strict_types=1);

namespace Drupal\mapsemble\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Site\Settings;
use Drupal\mapsemble\MapsembleApi;

/**
 * Configure Mapsemble settings for this site.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'mapsemble_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['mapsemble.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(
    array $form,
    FormStateInterface $form_state,
  ): array {
    $form['client_id'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Client ID'),
      '#default_value' => $this->config('mapsemble.settings')->get('client_id'),
      '#description' => $this->t(
          'Get your Client ID  on <a href="@link" target="_blank">Mapsemble</a>. Add your Client ID here or to your settings.(local.).php file (preferred method) as as follows: <br><br> <code>$config[\'mapsemble.settings\'][\'client_id\'] = \'your-key\'</code>',
          [
            '@link' => (Settings::get('mapsemble_app_base') ?? MapsembleApi::MAPSEMBLE_APP_BASE) . '/drupal',
          ]
      ),
    ];
    $form['client_secret'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Client Secret'),
      '#default_value' => $this->config('mapsemble.settings')->get('client_secret'),
      '#description' => $this->t(
        'Get your Client Scret  on <a href="@link" target="_blank">Mapsemble</a>. Add your Client Secret here or to your settings.(local.).php file (preferred method) as as follows: <br><br> <code>$config[\'mapsemble.settings\'][\'client_secret\'] = \'your-key\'</code>',
        [
          '@link' => (Settings::get('mapsemble_app_base') ?? MapsembleApi::MAPSEMBLE_APP_BASE) . '/drupal',
        ]
      ),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(
    array &$form,
    FormStateInterface $form_state,
  ): void {
    $this->config('mapsemble.settings')
      ->set('client_id', $form_state->getValue('client_id'))
      ->set('client_secret', $form_state->getValue('client_secret'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
