<?php

namespace Drupal\mapsemble\Plugin\Field;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\mapsemble\Attribute\FieldPlugin;
use Drupal\mapsemble\Plugin\FieldPluginBase;

/**
 * Field mapping plugin for options to options-compatible fields.
 */
#[FieldPlugin(
  id: "options_field",
  label: new TranslatableMarkup("Options field mapper"),
  drupal_field_types: ["list_string", "list_integer", "list_float", "boolean"],
  mapsemble_field_types: ["options"],
)]
class OptionsField extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function mapValue(ContentEntityInterface $entity, string $fieldName, FieldDefinitionInterface $fieldDefinition, array $configuration = []): mixed {
    $items = $entity->get($fieldName);
    if ($items->isEmpty()) {
      return NULL;
    }

    $values = [];
    foreach ($items as $item) {
      // For list_* and boolean fields, the selected value is stored in 'value'.
      // Use getString() to normalize scalars to strings for Mapsemble payloads.
      $values[] = $item->get('value')->getString();
    }

    // Return a single scalar for single-value fields, otherwise an array of values.
    return $fieldDefinition->isMultiple() ? $values : ($values[0] ?? NULL);
  }

}
