<?php

namespace Drupal\mapsemble\Plugin\Field;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\mapsemble\Attribute\FieldPlugin;
use Drupal\mapsemble\Plugin\FieldPluginBase;

/**
 * Field mapping plugin for text to text.
 */
#[FieldPlugin(
  id: "text_field",
  label: new TranslatableMarkup("Text field mapper"),
  drupal_field_types: ["string", "text", "text_long", "entity_reference"],
  mapsemble_field_types: ["text"],
)]
class TextField extends FieldPluginBase {

  /**
   * {@inheritdoc}
   */
  public function mapValue(ContentEntityInterface $entity, string $fieldName, FieldDefinitionInterface $fieldDefinition, array $configuration = []): mixed {
    $items = $entity->get($fieldName);
    if ($items->isEmpty()) {
      return NULL;
    }
    // Prefer value property for text-like fields.
    $values = [];
    foreach ($items as $item) {
      $values[] = $item->get('value')->getString();
    }
    // Return a single string if field is single-valued, otherwise array.
    return $fieldDefinition->isMultiple() ? $values : ($values[0] ?? NULL);
  }

}
