<?php

namespace Drupal\mapsemble\Plugin;

use Drupal\Component\Plugin\PluginBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for Field mapping plugins.
 */
abstract class FieldPluginBase extends PluginBase implements FieldPluginInterface, ContainerFactoryPluginInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  public function __construct(array $configuration, $plugin_id, $plugin_definition, EntityTypeManagerInterface $entity_type_manager) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function appliesToDrupalFieldType(string $fieldType): bool {
    $fieldTypes = $this->pluginDefinition['drupal_field_types'] ?? [];
    return in_array($fieldType, $fieldTypes, TRUE);
  }

  /**
   * {@inheritdoc}
   */
  public function appliesToMapsembleFieldType(string $mapsembleFieldType): bool {
    $types = $this->pluginDefinition['mapsemble_field_types'] ?? [];
    return in_array($mapsembleFieldType, $types, TRUE);
  }

}
