# Mapsemble Drupal Module

## Overview

The **Mapsemble** Drupal module provides seamless integration between [Mapsemble](https://mapsemble.com) and Drupal, allowing you to build dynamic, interactive maps using your Drupal entities. Whether you're showcasing locations, events, stories, or listings, Mapsemble brings your content to life with beautiful, customizable maps.

## Features

- **Entity-Based Mapping** – Build maps from any Drupal entity (nodes, taxonomy terms, etc.) using your existing content.
- **Customizable Cards & Popups** – Control the styling and layout of map cards and popups directly from Drupal for a fully tailored look and feel.
- **No Code Required** – Site builders can configure and style maps through the UI—no custom development necessary.
- **Live Data Sync** – Maps automatically reflect updates to your Drupal content.
- **Flexible Styling** – Match the look and feel of your site using Drupal’s theming system.

## Live Demo

🗺️ **Check out the live demo site:**
[https://drupal.mapsemble.com](https://drupal.mapsemble.com)

📦 **Want to build the same example?**
Install the demo content module:
[Mapsemble Store Locator Demo Content](https://www.drupal.org/project/mapsemble_store_locator_demo_content)
This provides preconfigured content and a ready-to-use map so you can get started quickly.

## Use Cases

- Store locators
- Event and venue maps
- Business directories
- Historical or cultural storytelling
- Real estate listings

## Why Use Mapsemble with Drupal?

This module brings together Drupal’s robust content management and Mapsemble’s powerful, user-friendly map builder. The result? A low-code solution for creating rich, spatial experiences that are easy to manage, customize, and scale.

---

For more information about Mapsemble, visit [https://mapsemble.com](https://mapsemble.com).
