<?php

namespace Drupal\mapsemble\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Drupal\mapsemble\Entity\MapsembleMap;
use Drupal\mapsemble\MapsembleApi;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;

/**
 * Controller for Mapsemble batch operations.
 */
class AdminController extends ControllerBase {

  /**
   * The Mapsemble API service.
   *
   * @var \Drupal\mapsemble\MapsembleApi
   */
  protected MapsembleApi $mapsembleApi;

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('mapsemble.api'),
    );
  }

  /**
   * Constructs a new MapsembleAdminController.
   *
   * @param \Drupal\mapsemble\MapsembleApi $mapsembleApi
   *   The Mapsemble API service.
   */
  public function __construct(
    MapsembleApi $mapsembleApi,
  ) {
    $this->mapsembleApi = $mapsembleApi;
  }

  /**
   * Synchronizes all entities for a specific map.
   *
   * @param \Drupal\mapsemble\Entity\MapsembleMap $mapsemble_map
   *   The map entity to synchronize.
   *
   * @return \Symfony\Component\HttpFoundation\RedirectResponse
   *   A redirect response to the batch processing page.
   */
  public function syncAllEntities(MapsembleMap $mapsemble_map): RedirectResponse {
    $batch_builder = $this->mapsembleApi->buildBatchForSyncing($mapsemble_map);
    batch_set($batch_builder->toArray());
    return batch_process(Url::fromRoute('entity.mapsemble_map.collection')->toString());
  }

}
