<?php

namespace Drupal\mapsemble\Controller;

use Drupal\mapsemble\Entity\MapsembleMap;

/**
 * Controller for bare content without site theming.
 */
class PopupController extends ContentControllerBase {

  /**
   * Returns the base template key for popup rendering.
   *
   * @return string
   *   The base string used to resolve templates for popups.
   */
  public function getBase(): string {
    return 'popup';
  }

  public function getBuild(MapsembleMap $mapsembleMap): array {
    $build = parent::getBuild(
      $mapsembleMap
    );
    $build['content']['#attributes']['class'][] = 'mapsemble-popup';
    return $build;
  }

}
