<?php

declare(strict_types=1);

namespace Drupal\mapsemble\Plugin\Field\FieldType;

use Drupal\Core\Field\Attribute\FieldType;
use Drupal\Core\Field\FieldItemBase;
use Drupal\Core\Field\FieldStorageDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\TypedData\DataDefinition;

/**
 * Field type storing a reference to a Mapsemble map config entity (by ID).
 */
#[FieldType(
  id: 'mapsemble_map',
  label: new TranslatableMarkup('Mapsemble map'),
  description: new TranslatableMarkup('Stores the ID of a Mapsemble map configuration entity.'),
  category: 'general',
  default_widget: 'mapsemble_map_select',
  default_formatter: 'mapsemble_map'
)]
final class MapsembleMapItem extends FieldItemBase {

  /**
   * {@inheritdoc}
   */
  public static function propertyDefinitions(FieldStorageDefinitionInterface $field_definition): array {
    $properties['map_id'] = DataDefinition::create('string')
      ->setLabel(new TranslatableMarkup('Map ID'))
      ->setRequired(FALSE);

    return $properties;
  }

  /**
   * {@inheritdoc}
   */
  public static function schema(FieldStorageDefinitionInterface $field_definition): array {
    return [
      'columns' => [
        'map_id' => [
          'type' => 'varchar',
          'length' => 128,
          'not null' => FALSE,
        ],
      ],
      'indexes' => [
        'map_id' => ['map_id'],
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function isEmpty(): bool {
    $value = $this->get('map_id')->getValue();
    return $value === NULL || $value === '';
  }

}
