<?php

namespace Drupal\mapsemble\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Interface for Field mapping plugins.
 */
interface FieldPluginInterface extends PluginInspectionInterface {

  /**
   * Checks if this plugin applies to the given Drupal field type.
   */
  public function appliesToDrupalFieldType(string $fieldType): bool;

  /**
   * Checks if this plugin applies to the given Mapsemble field type.
   */
  public function appliesToMapsembleFieldType(string $mapsembleFieldType): bool;

  /**
   * Maps the Drupal field value to a Mapsemble-compatible value.
   *
   * @param \Drupal\Core\Entity\ContentEntityInterface $entity
   *   The source entity.
   * @param string $fieldName
   *   The Drupal field name on the entity.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $fieldDefinition
   *   The Drupal field definition.
   * @param array $configuration
   *   Plugin-specific configuration, if any.
   *
   * @return mixed
   *   The mapped value suitable for Mapsemble payloads.
   */
  public function mapValue(ContentEntityInterface $entity, string $fieldName, FieldDefinitionInterface $fieldDefinition, array $configuration = []): mixed;

}
