<?php

namespace Drupal\mapsemble\Plugin\Filter;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\mapsemble\Attribute\FilterPlugin;
use Drupal\mapsemble\Plugin\FilterPluginBase;

/**
 * Filter plugin for text and string fields.
 */
#[FilterPlugin(
  id: "text_field_filter",
  label: new TranslatableMarkup("Text Field Filter"),
  field_types: [
    "string",
    "text",
    "string_long",
    "text_long",
    "text_with_summary",
  ],
)]
class TextFieldFilter extends FilterPluginBase {

  /**
   * {@inheritdoc}
   */
  public function filter(string $entityTypeId, string $bundle, string $fieldName, FieldDefinitionInterface $fieldDefinition, string|array $value = ''): array {
    $entityStorage = $this->entityTypeManager->getStorage($entityTypeId);
    $definition = $this->entityTypeManager->getDefinition($entityTypeId);

    // Build base query.
    $query = $entityStorage->getQuery()
      ->condition('status', 1)
      ->accessCheck(FALSE);

    if ($definition->hasKey('bundle')) {
      $query->condition($definition->getKey('bundle'), $bundle);
    }

    // Only get entities that have a value for this field.
    $query->exists($fieldName);

    // Filter by value using case-insensitive CONTAINS if provided.
    if (!empty($value)) {
      $query->condition($fieldName, $value, 'CONTAINS');
    }

    $entityIds = $query->execute();

    // Return entity IDs as array values (not associative).
    return array_values($entityIds);
  }

}
