<?php

namespace Drupal\mapsemble\Plugin;

use Drupal\Component\Plugin\PluginInspectionInterface;
use Drupal\Core\Field\FieldDefinitionInterface;

/**
 * Interface for Filter plugins.
 */
interface FilterPluginInterface extends PluginInspectionInterface {

  /**
   * Filters entities and returns entity IDs.
   *
   * @param string $entityTypeId
   *   The entity type ID.
   * @param string $bundle
   *   The bundle.
   * @param string $fieldName
   *   The field name.
   * @param \Drupal\Core\Field\FieldDefinitionInterface $fieldDefinition
   *   The field definition.
   * @param string $value
   *   The search value to filter by.
   *
   * @return array
   *   An array of entity IDs.
   */
  public function filter(string $entityTypeId, string $bundle, string $fieldName, FieldDefinitionInterface $fieldDefinition, string|array $value = ''): array;

  /**
   * Checks if this plugin applies to the given field type.
   *
   * @param string $fieldType
   *   The field type.
   *
   * @return bool
   *   TRUE if this plugin applies to the field type, FALSE otherwise.
   */
  public function appliesTo(string $fieldType): bool;

}
