<?php

namespace Drupal\markdown\Annotation;

/**
 * Markdown Allowed HTML Annotation.
 *
 * @Annotation
 */
class MarkdownAllowedHtml extends InstallablePlugin {

  /**
   * The provider of the annotated class.
   *
   * @var string
   */
  public $provider;

  /**
   * The type of object this allowed HTML is associated with.
   *
   * Can be one of: extension, filter, parser, module, theme.
   *
   * @var string
   */
  public $type;

  /**
   * {@inheritdoc}
   */
  protected function protectedProperties() {
    return array_merge(parent::protectedProperties(), ['type']);
  }

}
