<?php

namespace Drupal\markdown\Plugin\Markdown\CommonMark\Extension;

use Drupal\markdown\Plugin\Markdown\CommonMark\BaseExtension;

/**
 * Attributes extension.
 *
 * @MarkdownExtension(
 *   id = "commonmark-attributes",
 *   label = @Translation("Attributes"),
 *   description = @Translation("Adds a syntax to define attributes on the various HTML elements in markdown’s output."),
 *   libraries = {
 *     @ComposerPackage(
 *       id = "league/commonmark",
 *       object = "\League\CommonMark\Extension\Attributes\AttributesExtension",
 *       customLabel = "commonmark-attributes",
 *       url = "https://commonmark.thephpleague.com/extensions/attributes/",
 *       requirements = {
 *          @InstallableRequirement(
 *             id = "parser:commonmark",
 *             callback = "::getVersion",
 *             constraints = {"Version" = "^1.5 || ^2.0"},
 *          ),
 *       },
 *     ),
 *   },
 * )
 */
class AttributesExtension extends BaseExtension {
}
