<?php

namespace Drupal\markdown\Plugin\Markdown\CommonMark\Extension;

use Drupal\markdown\Plugin\Markdown\CommonMark\BaseExtension;

/**
 * Autolink extension.
 *
 * @MarkdownExtension(
 *   id = "commonmark-autolink",
 *   label = @Translation("Autolink"),
 *   description = @Translation("Automatically links URLs and email addresses even when the CommonMark <code>&lt;...&gt;</code> autolink syntax is not used."),
 *   libraries = {
 *     @ComposerPackage(
 *       id = "league/commonmark",
 *       object = "\League\CommonMark\Extension\Autolink\AutolinkExtension",
 *       customLabel = "commonmark-autolink",
 *       url = "https://commonmark.thephpleague.com/extensions/autolinks/",
 *       requirements = {
 *          @InstallableRequirement(
 *             id = "parser:commonmark",
 *             callback = "::getVersion",
 *             constraints = {"Version" = "^1.3 || ^2.0"},
 *          ),
 *       },
 *     ),
 *   },
 * )
 */
class AutolinkExtension extends BaseExtension {
}
