<?php

namespace Drupal\markdown\Plugin\Markdown\CommonMark\Extension;

use Drupal\Core\Theme\ActiveTheme;
use Drupal\markdown\Plugin\Markdown\AllowedHtmlInterface;
use Drupal\markdown\Plugin\Markdown\CommonMark\BaseExtension;
use Drupal\markdown\Plugin\Markdown\ParserInterface;

/**
 * Strikethrough extension.
 *
 * @MarkdownAllowedHtml(
 *   id = "commonmark-strikethrough",
 * )
 * @MarkdownExtension(
 *   id = "commonmark-strikethrough",
 *   label = @Translation("Strikethrough"),
 *   description = @Translation("Adds support for GFM-style strikethrough syntax. It allows users to use <code>~~</code> in order to indicate text that should be rendered within <code>&lt;del&gt;</code> tags."),
 *   libraries = {
 *     @ComposerPackage(
 *       id = "league/commonmark",
 *       object = "\League\CommonMark\Extension\Strikethrough\StrikethroughExtension",
 *       customLabel = "commonmark-strikethrough",
 *       url = "https://commonmark.thephpleague.com/extensions/strikethrough/",
 *       requirements = {
 *          @InstallableRequirement(
 *             id = "parser:commonmark",
 *             callback = "::getVersion",
 *             constraints = {"Version" = "^1.3 || ^2.0"},
 *          ),
 *       },
 *     ),
 *   },
 * )
 */
class StrikethroughExtension extends BaseExtension implements AllowedHtmlInterface {

  /**
   * {@inheritdoc}
   */
  public function allowedHtmlTags(ParserInterface $parser, ?ActiveTheme $activeTheme = NULL) {
    return [
      'del' => [],
    ];
  }

}
