<?php

namespace Drupal\markdown\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Checks whether a specific class, interface, trait, or function exists.
 *
 * @Constraint(
 *   id = "Exists",
 *   label = @Translation("Exists constraint", context = "Validation"),
 * )
 *
 * @internal
 */
class Exists extends Constraint {

  /**
   * The violation message.
   *
   * @var string
   */
  public $message = '@name does not exist.';

}
