<?php

namespace Drupal\markdown\Plugin\Validation\Constraint;

use Drupal\Core\Render\Markup;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates that a class, interface, trait, or function exists.
 *
 * @internal
 */
class ExistsValidator extends ConstraintValidator {

  /**
   * Optional name variable to translate.
   *
   * @var string|null
   */
  public ?string $name = NULL;

  /**
   * {@inheritdoc}
   */
  public function validate($class, Constraint $constraint) {
    if (!is_string($class) || empty($class) || (!class_exists($class) && !interface_exists($class) && !trait_exists($class) && !function_exists($class) && !defined($class) && !is_callable($class))) {
      $replacements = [
        '@name' => isset($constraint->name) ? Markup::create($constraint->name) : (string) $class,
      ];
      $this->context->addViolation($constraint->message, $replacements);
    }
  }

}
