<?php

namespace Drupal\markdown\Plugin\Validation\Constraint;

/**
 * Checks whether a specific class, interface, trait, or function exists.
 *
 * @Constraint(
 *   id = "Installed",
 *   label = @Translation("Installed constraint", context = "Validation"),
 * )
 *
 * @internal
 */
class Installed extends Exists {

  /**
   * The violation message.
   *
   * @var string
   */
  public $message = 'Requires @name';

  /**
   * Optional name for the dependency.
   *
   * @var string|null
   */
  public $name;

  /**
   * {@inheritdoc}
   */
  public function validatedBy(): string {
    return '\Drupal\markdown\Plugin\Validation\Constraint\ExistsValidator';
  }

}
