<?php

namespace Drupal\markdown\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Checks whether a specific version is satisfied by Semver constraints.
 *
 * @Constraint(
 *   id = "Version",
 *   label = @Translation("Version constraint", context = "Validation"),
 * )
 *
 * @internal
 */
class Version extends Constraint {

  /**
   * The default violation message.
   *
   * @var string
   */
  public $message = 'Version "@version" does not satisfy the following semantic version constraints "@constraints".';

  /**
   * The violation message when a name is provided.
   *
   * @var string
   */
  public $namedMessage = 'Requires @name:@constraints';

  /**
   * Optional requirement name.
   *
   * @var string
   */
  public $name;

  /**
   * Semver constraints to validate.
   *
   * @var string|null
   */
  public $value;

}
