<?php

namespace Drupal\markdown\Plugin\Validation\Constraint;

use Composer\Semver\Semver;
use Composer\Semver\VersionParser;
use Drupal\Core\Render\Markup;
use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Validates that a field is unique for the given entity type.
 *
 * @internal
 */
class VersionValidator extends ConstraintValidator {

  /**
   * Semver version parser.
   *
   * @var \Composer\Semver\VersionParser
   */
  private static ?VersionParser $versionParser = NULL;

  /**
   * {@inheritdoc}
   */
  public function validate($version, Constraint $constraint) {
    /** @var \Drupal\markdown\Plugin\Validation\Constraint\Version $constraint */
    $semverConstraints = $constraint->value;

    $named = isset($constraint->name);
    $message = $named ? $constraint->namedMessage : $constraint->message;
    $placeholders = [
      '@name' => $named ? Markup::create($constraint->name) : 'Unknown',
      '@constraints' => $semverConstraints ? Markup::create($semverConstraints) : '',
      '@version' => $version ? Markup::create($version) : '',
    ];
    $validated = FALSE;

    try {
      if (!empty($version)) {
        if (!empty($semverConstraints)) {
          $validated = Semver::satisfies($version, $semverConstraints);
        }
        else {
          self::$versionParser ??= new VersionParser();
          $validated = (bool) self::$versionParser->normalize($version);
        }
      }
    }
    catch (\UnexpectedValueException $exception) {
      $message = $exception->getMessage();
      $placeholders = [];
    }

    if (!$validated) {
      $this->context->addViolation($message, $placeholders);
    }
  }

}
