<?php

namespace Drupal\markdown\Traits;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a lightweight container-aware implementation.
 *
 * Symfony removed its ContainerAwareTrait in 6.0, so we ship an equivalent
 * implementation here to keep existing code working across versions.
 */
trait ContainerAwareTrait {

  /**
   * Service container instance.
   *
   * @var \Symfony\Component\DependencyInjection\ContainerInterface|null
   */
  protected $container;

  /**
   * Sets the service container.
   *
   * @param \Symfony\Component\DependencyInjection\ContainerInterface|null $container
   *   The container.
   */
  public function setContainer(?ContainerInterface $container = NULL) {
    $this->container = $container;
  }

}
