<?php

namespace Drupal\markdown\Traits;

use GuzzleHttp\Utils;

/**
 * Trait to help with creating an HTTP client using module info as user-agent.
 */
trait HttpClientTrait {

  /**
   * The HTTP client.
   *
   * @var \GuzzleHttp\Client
   */
  protected static $httpClient;

  /**
   * Retrieves an HTTP client.
   *
   * @param string $name
   *   A Drupal extension machine name.
   * @param string $type
   *   The type of Drupal extension, e.g. module or theme.
   *
   * @return \GuzzleHttp\Client
   *   An HTTP client.
   */
  protected static function httpClient($name = 'markdown', $type = 'module') {
    if (!static::$httpClient) {
      $info = ['name' => $name];
      try {
        $info = \Drupal::service('extension.list.' . $type)->getExtensionInfo($name);
      }
      catch (\Exception) {
        // Extension info is optional while the module is being installed.
      }
      $extension = $info['name'] ?? $name;
      if ($info && !empty($info['version'])) {
        $extension .= '/' . $info['version'];
      }
      $extension .= " (+https://www.drupal.org/project/$name)";

      /** @var \Drupal\Core\Http\ClientFactory $httpClientFactory */
      $httpClientFactory = \Drupal::service('http_client_factory');
      static::$httpClient = $httpClientFactory->fromOptions([
        'headers' => [
          'User-Agent' => $extension . ' Drupal/' . \Drupal::VERSION . ' (+https://www.drupal.org/) ' . Utils::defaultUserAgent(),
        ],
      ]);
    }
    return static::$httpClient;
  }

}
