<?php

namespace Drupal\markdown\Util;

use Composer\InstalledVersions;

/**
 * Composer utility helpers.
 */
class Composer {

  /**
   * Attempts to resolve the installed package version for a class.
   *
   * @param string $class
   *   The class name to resolve.
   *
   * @return string|null
   *   The detected version or NULL when unavailable.
   */
  public static function getVersionFromClass(string $class): ?string {
    if (!class_exists($class) && !interface_exists($class) && !trait_exists($class)) {
      return NULL;
    }

    try {
      $reflection = new \ReflectionClass($class);
    }
    catch (\ReflectionException $exception) {
      return NULL;
    }

    $file = $reflection->getFileName();
    if (!$file) {
      return NULL;
    }

    $dir = dirname($file);
    while ($dir && $dir !== dirname($dir)) {
      $composer_path = $dir . '/composer.json';
      if (is_file($composer_path)) {
        $contents = file_get_contents($composer_path);
        $json = $contents !== FALSE ? json_decode($contents, TRUE) : NULL;
        $package = is_array($json) && !empty($json['name']) ? $json['name'] : NULL;
        if (!$package || !class_exists(InstalledVersions::class)) {
          return NULL;
        }
        if (InstalledVersions::isInstalled($package)) {
          return InstalledVersions::getPrettyVersion($package)
            ?: InstalledVersions::getVersion($package);
        }
        return NULL;
      }
      $dir = dirname($dir);
    }

    return NULL;
  }

}
