<?php

namespace Drupal\Tests\markdown\Kernel\Plugin\Markdown;

use Drupal\markdown\Plugin\Markdown\RenderStrategyInterface;

/**
 * Tests rendering text using the CommonMark parser.
 *
 * @coversDefaultClass \Drupal\markdown\Plugin\Markdown\CommonMark\CommonMark
 * @group markdown
 */
class CommonMarkTest extends MarkdownParserTestBase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->parser = $this->container->get('plugin.manager.markdown.parser')
      ->createInstance('commonmark');

    $config = $this->parser->getConfiguration();
    $config['render_strategy']['type'] = RenderStrategyInterface::NONE;
    $this->parser->setConfiguration($config);
  }

}
