<?php

namespace Drupal\Tests\markdown\Kernel\Plugin\Markdown;

use Drupal\Tests\markdown\Kernel\MarkdownKernelTestBase;
use Drupal\markdown\Plugin\Markdown\ParserInterface;
use Drupal\markdown\Render\ParsedMarkdownInterface;

/**
 * Base class for MarkdownParser plugin tests.
 */
abstract class MarkdownParserTestBase extends MarkdownKernelTestBase {

  /**
   * An instance of the markdown parser to test.
   *
   * @var \Drupal\markdown\Plugin\Markdown\ParserInterface
   */
  protected ParserInterface $parser;

  /**
   * Ensures parser implementations render expected HTML.
   *
   * @dataProvider parseDataProvider
   */
  public function testParse(string $expected_html, string $input) {
    $result = $this->parser->parse($input);
    $this->assertInstanceof(ParsedMarkdownInterface::class, $result);
    $this->assertEquals($expected_html, $result->getHtml());
  }

  /**
   * Data provider for testParse().
   */
  public static function parseDataProvider(): array {
    $cases = [
      'bold' => [
        'expected_html' => '<p><strong>Bold</strong></p>',
        'input' => '**Bold**',
      ],
      'italic' => [
        'expected_html' => '<p><em>Italic</em></p>',
        'input' => '*Italic*',
      ],
      'link' => [
        'expected_html' => '<p><a href="https://example.com">Example link</a></p>',
        'input' => '[Example link](https://example.com)',
      ],
    ];

    return $cases;
  }

}
