<?php

namespace Drupal\Tests\markdown\Kernel\Plugin\Markdown;

use Drupal\markdown\Plugin\Markdown\RenderStrategyInterface;

/**
 * Tests rendering text using the PHP Markdown Extra parser.
 *
 * @coversDefaultClass \Drupal\markdown\Plugin\Markdown\PhpMarkdown\PhpMarkdownExtra
 * @group markdown
 */
class PhpMarkdownExtraTest extends MarkdownParserTestBase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->parser = $this->container->get('plugin.manager.markdown.parser')
      ->createInstance('php-markdown-extra');

    $config = $this->parser->getConfiguration();
    $config['render_strategy']['type'] = RenderStrategyInterface::NONE;
    $this->parser->setConfiguration($config);
  }

}
