<?php

namespace Drupal\markdownify;

/**
 * Interface for managing and validating supported entity types.
 *
 * Defines methods for retrieving and checking the supported entity types
 * that Markdownify can process.
 */
interface MarkdownifySupportedEntityTypesValidatorInterface {

  /**
   * Gets the supported entities configuration.
   *
   * @return array
   *   An associative array of supported entity type configurations.
   */
  public function getSupportedEntities(): array;

  /**
   * Retrieves the list of entity types supported by Markdownify.
   *
   * @return string[]
   *   An array of supported entity type IDs.
   *
   * @deprecated in markdownify:1.1.1 and is removed from markdownify:2.0.0. Use
   *   ::getSupportedEntities() instead, which provides richer configuration
   *   details and improved flexibility.
   *
   * @see https://www.drupal.org/project/markdownify/issues/3547314
   */
  public function getSupportedEntityTypes(): array;

  /**
   * Checks if a given entity type is supported by Markdownify.
   *
   * @param string $entity_type
   *   The entity type ID to check.
   *
   * @return bool
   *   TRUE if the entity type is supported, FALSE otherwise.
   */
  public function isSupported(string $entity_type): bool;

}
