
(function (Drupal, drupalSettings) {
  'use strict';

  function initWrap(wrap, speed, gap, direction) {
    const track = wrap.querySelector('.marquee-scroll-track');
    if (!track) return;

    wrap.style.setProperty('--ms-gap', (gap || 60) + 'px');

    let unit = 0;
    const measure = () => {
      const first = track.querySelector('.marquee-scroll-item');
      if (!first) return;
      const rect = first.getBoundingClientRect();
      unit = (direction === 'up' || direction === 'down')
        ? rect.height + (gap || 60)
        : rect.width + (gap || 60);
    };
    measure();

    let pos = 0;
    let last = performance.now();

    const step = (now) => {
      const dt = (now - last) / 1000;
      last = now;
      const s = (speed || 40) * dt;
      switch (direction) {
        case 'right': pos += s; break;
        case 'up': pos -= s; break;
        case 'down': pos += s; break;
        default: pos -= s; // left
      }

      if (unit > 0 && Math.abs(pos) > unit) {
        pos += (pos < 0 ? 1 : -1) * unit;
      }

      if (direction === 'up' || direction === 'down') {
        track.style.transform = 'translateY(' + pos + 'px)';
      } else {
        track.style.transform = 'translateX(' + pos + 'px)';
      }
      requestAnimationFrame(step);
    };

    requestAnimationFrame(step);
    window.addEventListener('resize', measure, { passive: true });
  }

  Drupal.behaviors.marqueeScroll = {
    attach: function (context) {
      const defaults = drupalSettings.marquee_scroll || {};
      context.querySelectorAll('.marquee-scroll-wrap').forEach((wrap) => {
        const speed = parseInt(wrap.getAttribute('data-ms-speed') || defaults.speed || '40', 10);
        const gap = parseInt(wrap.getAttribute('data-ms-gap') || defaults.gap || '60', 10);
        const direction = (wrap.getAttribute('data-ms-direction') || defaults.direction || 'left').toLowerCase();
        initWrap(wrap, speed, gap, direction);
      });
    }
  };
})(Drupal, drupalSettings);
