
<?php

namespace Drupal\Tests\marquee_scroll\Kernel;

use Drupal\KernelTests\KernelTestBase;

/**
 * Kernel test to ensure the field formatter plugin exists.
 *
 * @group marquee_scroll
 */
class MarqueeScrollKernelTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['system', 'user', 'field', 'filter', 'text', 'marquee_scroll'];

  /**
   * Tests the formatter can be discovered and instantiated.
   */
  public function testFormatterDiscovery() {
    $manager = \Drupal::service('plugin.manager.field.formatter');
    $definitions = $manager->getDefinitions();
    $this->assertArrayHasKey('marquee_scroll_formatter', $definitions, 'Formatter definition is registered.');

    $instance = $manager->createInstance('marquee_scroll_formatter', []);
    $this->assertNotNull($instance);
  }

}
