Menu dropdown
=============

Material Base provides JS for handling menu dropdowns.

Menu dropdown component uses the Menu component from the MDC library and supports all its features.

[Button component](button.md) could be used as a menu dropdown toggle as well.

Component implemented as CSS classes for using in markup.

Component classes
-----------------

* `mdc-menu-dropdown` - menu dropdown root element
* `mdc-menu-dropdown__toggle` - menu dropdown toggle
* `mdc-menu` - dropdown menu (MDC component)
* `mdc-menu-dropdown__group` - (optional) wrapper for hadling menu dropdown group behaviour

Examples of usage
-----------------

### Button with menu dropdown

In the Twig template file:

~~~
<div class="mdc-menu-dropdown">
  {% include "@material_base_mdc/components/02_molecules/button.twig" with {
    data: {
      label: 'Dropdown',
    },
    settings: {
      classes: ['mdc-menu-dropdown__toggle'],
    },
  } %}
  <div class="mdc-menu-surface--anchor">
    <div class="mdc-menu mdc-menu-surface" data-mdc-auto-init="MDCMenu">
      <ul class="mdc-deprecated-list" role="menu" aria-hidden="true" aria-orientation="vertical" tabindex="-1" data-mdc-auto-init="MDCList">
        <li class="mdc-deprecated-list-item" role="menuitem" data-mdc-auto-init="MDCRipple">
          <span class="mdc-deprecated-list-item__ripple"></span>
          <span class="mdc-deprecated-list-item__text">A Menu Item</span>
        </li>
        <li class="mdc-deprecated-list-item" role="menuitem" data-mdc-auto-init="MDCRipple">
          <span class="mdc-deprecated-list-item__ripple"></span>
          <span class="mdc-deprecated-list-item__text">Another Menu Item</span>
        </li>
      </ul>
    </div>
  </div>
</div>
~~~

Output: Button with menu dropdown.
