Material Base theme folder structure
================

Files and folders of Material Base:

* `📁 config` - contains default blocks configuration and theme settings
* `📁 dist` - contains built assets (CSS, JS, images, SVG icons sprite)
* `📁 docs` - contains documentation
* `📁 icons` - source folder for building SVG icons sprite
* `📁 images` - source folder for CSS used images like backgrounds
* `📁 js` - source folder for JS files
* `📁 scss` - source folder for Sass files
* `📁 templates` - contains Twig templates for Drupal elements and theme components
* `📁 themes/material_base_mdc` - "Material Base MDC" theme folder
* `📁 themes/material_base_subtheme` - example kit for creating your custom subtheme
* `📁 themes/material_stable9` - "Material Stable 9" theme folder
* `📄 .gitignore` - contains exclusions for Git repository
* `📄 .prettierignore` - contains exclusions for Prettier
* `📄 .prettierrc` - contains configuration for Prettier
* `📄 CHANGELOG.txt` - contains development changes log
* `📄 composer.json` - contains technical information about theme
* `📄 eslint.config.mjs` - contains configuration for ESLint
* `📄 favicon.ico` - theme favicon
* `📄 generate.php` - subtheme generation script
* `📄 logo.svg` - theme logo for Project Browser
* `📄 logo.svg` - vector theme logo
* `📄 material_base.breakpoints.yml` - contains Drupal breakpoints definitions
* `📄 material_base.info.yml` - contains technical information about theme, used libraries, regions and other options
* `📄 material_base.libraries.yml` - contains Drupal libraries definitions
* `📄 material_base.post_update` - contains update functions
* `📄 material_base.theme` - contains functions used in theme
* `📄 package.json` - contains technical information about dependencies and building scripts
* `📄 package-lock.json` - contains technical information about dependencies versions
* `📄 README.md` - contains theme description
* `📄 screenshot.svg` - theme screenshot
* `📄 stylelint.config.mjs` - contains configuration for Stylelint
* `📄 theme-settings.php` - contains theme settings definition
* `📄 webpack.config.js` - contains build tasks configuration

Pretty much the same structure could be used for your custom theme, excluding `docs` and `themes` folders.
