<?php

declare(strict_types=1);

namespace Drupal\matomo_test\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Controller routines for system_test routes.
 */
class MatomoTestController extends ControllerBase {

  /**
   * Tests setting messages and removing one before it is displayed.
   *
   * @return array
   *   Empty array, we just test the setting of messages.
   */
  public function drupalAddMessageTest() {
    // Set some messages.
    $this->messenger()->addMessage($this->t('Example status message.'), 'status');
    $this->messenger()->addMessage($this->t('Example warning message.'), 'warning');
    $this->messenger()->addMessage($this->t('Example error message.'), 'error');
    $this->messenger()->addMessage($this->t('Example error <em>message</em> with html tags and <a href="https://example.com/">link</a>.'), 'error');

    return [];
  }

}
