<?php

namespace Drupal\matomo_preload\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Render\BubbleableMetadata;

/**
 * Hooks for matomo_preload.
 */
readonly class MatomoPreloadHooks {

  public function __construct(private ConfigFactoryInterface $configFactory) {}

  /**
   * Add link tags to head.
   *
   * @param mixed[] $attachments
   *   Attachments.
   *
   * @link https://www.drupal.org/project/drupal/issues/3366561
   */
  #[Hook('page_attachments')]
  public function pageAttachments(array &$attachments): void {
    $metadata = BubbleableMetadata::createFromRenderArray($attachments);

    $config = $this->configFactory->get('matomo.settings');
    $metadata->addCacheableDependency($config);
    if ($baseUrl = $config->get('url_https')) {
      $metadata->addAttachments(
        [
          'html_head_link' => [
            [
              [
                'rel' => 'dns-prefetch',
                'href' => $baseUrl,
              ],
              FALSE,
            ],
            [
              [
                'rel' => 'preload',
                'href' => rtrim($baseUrl, '/') . '/matomo.js',
                'as' => 'script',
              ],
              FALSE,
            ],
          ],
        ]
      );
    }

    $metadata->applyTo($attachments);
  }

}
