<?php

declare(strict_types=1);

namespace Drupal\mautic_api\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining a Mautic API Connection entity type.
 */
interface MauticApiConnectionInterface extends ConfigEntityInterface {

  /**
   * Gets the HTTP protocol.
   *
   * @return string
   *   The HTTP protocol (http/https).
   */
  public function getHttpProtocol(): string;

  /**
   * Gets the Mautic base URL.
   *
   * @return string
   *   The Mautic base URL.
   */
  public function getBaseUrl(): string;

  /**
   * Gets the Mautic port.
   *
   * @return string
   *   The Mautic port.
   */
  public function getPort(): string;

  /**
   * Gets the Mautic path.
   *
   * @return string
   *   The Mautic path.
   */
  public function getPath(): string;

  /**
   * Gets the authentication method.
   *
   * @return string
   *   The authentication method (oauth/basic).
   */
  public function getAuthMethod(): string;

  /**
   * Gets the OAuth public key.
   *
   * @return string
   *   The OAuth public key.
   */
  public function getPublicKey(): string;

  /**
   * Gets the OAuth secret key.
   *
   * @return string
   *   The OAuth secret key.
   */
  public function getSecretKey(): string;

  /**
   * Gets the Basic Auth username.
   *
   * @return string
   *   The Basic Auth username.
   */
  public function getBasicAuthUsername(): string;

  /**
   * Gets the Basic Auth password.
   *
   * @return string
   *   The Basic Auth password.
   */
  public function getBasicAuthPassword(): string;

  /**
   * Get the complete URL for a Mautic connection.
   *
   * @return string
   *   The complete URL for the connection.
   */
  public function getCompleteUrl(): string;

}
