<?php

declare(strict_types=1);

namespace Drupal\mautic_api;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of mautic api connections.
 */
final class MauticApiConnectionListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Label');
    $header['id'] = $this->t('Machine name');
    $header['site_url'] = $this->t('Site URL');
    $header['auth_type'] = $this->t('Authentication type');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\mautic_api\Entity\MauticApiConnection $entity */
    $row['label'] = $entity->label();
    $row['id'] = $entity->id();
    $row['site_url'] = $entity->getBaseUrl();
    $row['auth_type'] = $entity->getAuthMethod();
    return $row + parent::buildRow($entity);
  }

}
