<?php

namespace Drupal\mautic_api\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event dispatched when a Mautic webhook is received.
 */
class MauticWebhookEvent extends Event {

  /**
   * The webhook data.
   *
   * @var array
   */
  protected array $data;

  /**
   * Constructs a new MauticWebhookEvent.
   *
   * @param array $data
   *   The webhook data.
   */
  public function __construct(array $data) {
    $this->data = $data;
  }

  /**
   * Gets the webhook data.
   *
   * @return array
   *   The webhook data.
   */
  public function getData(): array {
    return $this->data;
  }

}
