<?php

declare(strict_types=1);

namespace Drupal\mautic_api\Entity;

use Drupal\Core\Config\Entity\ConfigEntityBase;

/**
 * Defines the Webhook config entity.
 *
 * @ConfigEntityType(
 *   id = "mautic_api_webhook",
 *   label = @Translation("Webhook"),
 *   label_collection = @Translation("Webhooks"),
 *   label_singular = @Translation("Webhook"),
 *   label_plural = @Translation("Webhooks"),
 *   label_count = @PluralTranslation(
 *     singular = "@count Webhook",
 *     plural = "@count Webhooks",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\mautic_api\WebhookListBuilder",
 *     "form" = {
 *       "add" = "Drupal\mautic_api\Form\WebhookForm",
 *       "edit" = "Drupal\mautic_api\Form\WebhookForm",
 *       "delete" = "Drupal\Core\Entity\EntityDeleteForm",
 *     },
 *   },
 *   config_prefix = "mautic_api_webhook",
 *   admin_permission = "administer mautic_api_webhook",
 *   links = {
 *     "collection" = "/admin/structure/mautic-api-webhook",
 *     "add-form" = "/admin/structure/mautic-api-webhook/add",
 *     "edit-form" = "/admin/structure/mautic-api-webhook/{mautic_api_webhook}",
 *     "delete-form" = "/admin/structure/mautic-api-webhook/{mautic_api_webhook}/delete",
 *   },
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   config_export = {
 *     "id",
 *     "label",
 *     "secret",
 *     "url",
 *   },
 * )
 */
final class Webhook extends ConfigEntityBase implements WebhookInterface {
  /**
   * The Webhook ID.
   */
  protected string $id;

  /**
   * The Webhook label (name).
   */
  protected string $label;

  /**
   * The Webhook secret.
   */
  protected string $secret;

  /**
   * The Webhook URL.
   */
  protected string $url;

  /**
   * {@inheritdoc}
   */
  public function getSecret(): string {
    return $this->secret;
  }

  /**
   * {@inheritdoc}
   */
  public function getUrl(): string {
    return $this->url;
  }

}
