<?php

declare(strict_types=1);

namespace Drupal\mautic_api\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining a Webhook config entity type.
 */
interface WebhookInterface extends ConfigEntityInterface {

  /**
   * Gets the Webhook secret.
   *
   * @return string
   *   The Webhook secret.
   */
  public function getSecret(): string;

  /**
   * Gets the Webhook URL.
   *
   * @return string
   *   The Webhook URL.
   */
  public function getUrl(): string;

}
