<?php

declare(strict_types=1);

namespace Drupal\mautic_api;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Entity\EntityInterface;

/**
 * Provides a listing of Webhook config entities.
 */
final class WebhookListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader(): array {
    $header['label'] = $this->t('Name');
    $header['url'] = $this->t('Webhook Source URL');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity): array {
    /** @var \Drupal\mautic_api\Entity\Webhook $entity */
    $row['label'] = $entity->label();
    $row['url'] = $entity->get('url');
    return $row + parent::buildRow($entity);
  }

}
