<?php

namespace Drupal\mautic_eca;

use Drupal\eca\Event\BaseHookHandler;

/**
 * The handler for hook implementations within the mautic_eca module.
 *
 * @internal
 *   This class is not meant to be used as a public API. It is subject for name
 *   change or may be removed completely, also on minor version updates.
 */
class HookHandler extends BaseHookHandler {

  /**
   * Triggers the event for when a Mautic webhook is received.
   *
   * @param array $data
   *   The webhook data from Mautic.
   */
  public function webhookReceived(array $data): void {
    $this->triggerEvent->dispatchFromPlugin('mautic_webhook_eca:webhook_received', $data);
  }

}
