## Introduction

Mautic ECA integrates the Drupal ECA module with the [Mautic](https://mautic.org/) marketing automation platform.

## Requirements

- Drupal core: ^10 || ^11
- Modules:
  - `eca` (^2.1)
  - `mautic_api` (^2.0)
- Recommended: `token` (for a better token UI in ECA)

## Installation

Install this module as you would any other Drupal module. With Composer:

```bash
composer require drupal/mautic_eca
```

Then install it (and its dependencies) in Drupal.

## Configuration

1. Create at least one Mautic API Connection via the `mautic_api` module.
2. (For Webhook) Configure one or more Mautic Webhook configuration entities in `mautic_api` and point your Mautic instance to the provided webhook URL.


## Available ECA Event

- Mautic: Webhook Received Event
  - Triggers whenever a webhook payload is received from Mautic (for the selected webhook configuration).
  - Provides a token (configurable name, default `webhook_data`) containing the raw webhook payload.

## Available ECA Actions

Contacts
- Mautic: Create Contact — Create a contact from JSON input.
- Mautic: Update Contact — Update a contact by Mautic ID with JSON input.
- Mautic: Delete Contact — Delete a contact by Mautic ID.
- Mautic: Get Contact — Retrieve a contact by Mautic ID.
- Mautic: List Contact — Find/list contacts with search, paging, and sorting options.
- Mautic: Add Contact to Do Not Contact — Add a contact to DNC with channel/reason/comments.
- Mautic: Remove Contact from Do Not Contact — Remove a contact from DNC for a channel.

Segments
- Mautic: Create Segment — Create a segment from JSON input.
- Mautic: Update Segment — Update a segment by Mautic ID with JSON input.
- Mautic: Delete Segment — Delete a segment by Mautic ID.
- Mautic: Get Segment — Retrieve a segment by Mautic ID.
- Mautic: List Segments — Find/list segments with search, paging, and sorting options.
- Mautic: Add Contact to Segment — Add a contact to a segment by IDs.

All actions require selecting a Mautic API connection and can optionally store the API response in a named token for use later in the model.
