<?php

namespace Drupal\mautic_eca\Event;

use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event for when a Mautic webhook is received.
 *
 * @package Drupal\mautic_eca\Event
 */
class MauticWebhookReceived extends Event {

  /**
   * The webhook data from Mautic.
   *
   * @var array
   */
  protected array $data;

  /**
   * Constructs a new MauticWebhookReceived event.
   *
   * @param array $data
   *   The webhook data from Mautic.
   */
  public function __construct(array $data) {
    $this->data = $data;
  }

  /**
   * Gets the webhook data.
   *
   * @return array
   *   The webhook data from Mautic.
   */
  public function getData(): array {
    return $this->data;
  }

}
