<?php

namespace Drupal\mautic_eca\EventSubscriber;

use Drupal\mautic_api\Event\MauticWebhookEvent;
use Drupal\mautic_eca\HookHandler;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Event subscriber for Mautic webhook events.
 */
class MauticWebhookEventSubscriber implements EventSubscriberInterface {

  /**
   * Constructs a new MauticWebhookEventSubscriber.
   *
   * @param \Drupal\mautic_eca\HookHandler $hookHandler
   *   The hook Handler.
   */
  public function __construct(protected HookHandler $hookHandler) {
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      'mautic_api.webhook_received' => ['onWebhookReceived'],
    ];
  }

  /**
   * Reacts to the Mautic webhook event.
   *
   * @param \Drupal\mautic_api\Event\MauticWebhookEvent $event
   *   The webhook event.
   */
  public function onWebhookReceived(MauticWebhookEvent $event): void {
    $data = $event->getData();

    // Dispatch the general webhook received event for ECA.
    $this->hookHandler->webhookReceived($data);
  }

}
